/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.BooleanValue debug;
    public static ForgeConfigSpec.BooleanValue opMode;
    public static ForgeConfigSpec.BooleanValue enableMysticalCrops;
    public static ForgeConfigSpec.BooleanValue useWhitelist;
    public static ForgeConfigSpec.IntValue range;
    public static ForgeConfigSpec.DoubleValue chance;
    public static ForgeConfigSpec.ConfigValue<List<String>> blacklist;
    public static ForgeConfigSpec.ConfigValue<List<String>> whitelist;

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        ArrayList<String> defaultBlacklist = new ArrayList<String>();
        defaultBlacklist.add("minecraft:grass_block");
        defaultBlacklist.add("minecraft:grass");
        defaultBlacklist.add("minecraft:tall_grass");
        defaultBlacklist.add("minecraft:netherrack");
        defaultBlacklist.add("minecraft:warped_nylium");
        defaultBlacklist.add("minecraft:crimson_nylium");
        BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        debug = BUILDER.comment("Enable debug logging").define("debug", false);
        opMode = BUILDER.comment(new String[]{"Enables OP mode!", "Enable at your own risk"}).define("opMode", false);
        enableMysticalCrops = BUILDER.comment("Enable mystical crops").define("enableMysticalCrops", true);
        useWhitelist = BUILDER.comment("Use whitelist instead of blacklist").define("useWhitelist", false);
        range = BUILDER.comment("Range for bonemeal effect").defineInRange("range", 3, 0, 16);
        chance = BUILDER.comment(new String[]{"Chance of bonemeal effect", "0 being never and 1.0 being most of the time"}).defineInRange("chance", 0.5, 0.0, 1.0);
        blacklist = BUILDER.comment(new String[]{"List of blocks to blacklist from twerking", "Tags can be used by using #minecraft:<tag_name> or #modid:<tag_name>"}).define("blacklist", defaultBlacklist);
        whitelist = BUILDER.comment(new String[]{"If useWhitelist is true use, only allow twerking the list below", "Tags can be used by using #minecraft:<tag_name> or #modid:<tag_name>"}).define("whitelist", new ArrayList());
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

